#ifndef __CFloat__
#define __CFloat__

//	===========================================================================

#include "CString.hpp"

//	===========================================================================

using Exponent::Basics::CString;

//	===========================================================================

namespace Exponent
{
	namespace Basics
	{
		/**
		 * @class CFloat CFloat.hpp
		 * @brief Wrapper around built in float type
		 *
		 * Basic wrapper around a built in float type giving it CCountedObject functionality
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CFloat.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CFloat : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param value The value to store
			 */
			CFloat(const float value = 0.f);

			/**
			 * Destruction
			 */
			virtual ~CFloat();

//	===========================================================================

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator = (const CFloat &value);

			/**
			 * Assignment operator
			 * @param value The value to store
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator = (const float value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if values are equal, false otherwise
			 */
			bool operator == (const CFloat &value);

			/**
			 * Equality operator
			 * @param value The value to compare to
			 * @retval bool True if values are equal, false otherwise
			 */
			bool operator == (const float value);

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if values are inequal, false otherwise
			 */
			bool operator != (const CFloat &value);

			/**
			 * InEquality operator
			 * @param value The value to compare to
			 * @retval bool True if values are inequal, false otherwise
			 */
			bool operator != (const float value);

			/**
			 * Addition operator
			 * @param value The value to add to this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator + (const CFloat &value);

			/**
			 * Addition operator
			 * @param value The value to add to this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator + (const float value);

			/**
			 * Subtraction operator
			 * @param value The value to subtract from this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator - (const CFloat &value);

			/**
			 * Subtraction operator
			 * @param value The value to subtract from this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator - (const float value);

			/**
			 * Multiplication operator
			 * @param value The value to multiply with this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator * (const CFloat &value);

			/**
			 * Multiplication operator
			 * @param value The value to multiply with this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator * (const float value);

			/**
			 * Division operator
			 * @param value The value to divide with this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator / (const CFloat &value);

			/**
			 * Division operator
			 * @param value The value to divide with this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator / (const float value);

			/**
			 * Plus equals operator
			 * @param value The value to add to this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator += (const CFloat &value);

			/**
			 * Plus equals operator
			 * @param value The value to add to this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator += (const float value);

			/**
			 * Neg equals operator
			 * @param value The value to subtract from this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator -= (const CFloat &value);

			/**
			 * Neg equals operator
			 * @param value The value to subtract from this
			 * @retval CFloat& A reference to this
			 */
			CFloat &operator -= (const float value);

			/**
			 * ! operator
			 * @retval bool True if value == 0, false otherwise
			 */
			bool operator ! ();

//	===========================================================================

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const CFloat &value);

			/**
			 * Set the value
			 * @param value The value to store
			 */
			void setValue(const float value);

			/**
			 * Get the value
			 * @retval double The value
			 */
			float getValue() const;

			/**
			 * Get as a string
			 * @param decimalPlaces The number of decimal places precision required
			 * @retval CString* The double as a string (up to you to delete the CString returned)
			 */
			CString getValueAsString(const long decimalPlaces = 2) const;

//	===========================================================================

			/**
			 * Get a description of the object
			 * @param string On return is filled with the description
			 * @param size The size of the stirng
			 */
			virtual void getObjectDescription(char *string, const long size) const;

//	===========================================================================

		protected:

//	===========================================================================

			float m_value;			/**< The value stored */

		};
	}
}
#endif	// End of CFloat.hpp